using RimWorld;
using Verse;
using Verse.AI;

namespace Therapy
{
    public class WorkGiver_Therapist : WorkGiver_Scanner
    {
        public override ThingRequest PotentialWorkThingRequest
        {
            get
            {
                return ThingRequest.ForGroup(ThingRequestGroup.BuildingArtificial);
            }
        }

        public override bool Prioritized
        {
            get
            {
                return true;
            }
        }

        public override bool HasJobOnThing(Pawn pawn, Thing couch, bool forced = false)
        {
            if (!(couch is Building_Couch))return false;
            var patient = couch.Position.GetFirstPawn(couch.Map);
            if(patient == null || patient == pawn || patient.Dead || patient.Downed || patient.InMentalState) return false;
            if(!pawn.CanReserve(patient, 1, -1, null, forced)) return false;

            Thing chair;
            MainUtility.TryFindChairNearCouch((Building_Couch) couch, out chair);

            if (chair == null) return false;
            if (chair.IsForbidden(pawn)) return false;
            if (!pawn.CanReserveAndReach(chair, PathEndMode.InteractionCell, Danger.None, 1, -1, null, forced)) return false;
            //var room = t.GetRoom();
            //if (room == null)// || room.Role != ModBaseTherapy.therapyRoomRoleDef) 
            //    return false;

            //return room.ContainedAndAdjacentThings.Any(c => c is Building_Bed);

            return true;
        }

        public override Job JobOnThing(Pawn pawn, Thing couch, bool forced = false)
        {
            Thing chair;
            MainUtility.TryFindChairNearCouch((Building_Couch)couch, out chair);
            
            return new Job(MainUtility.therapistJobDef, chair, couch.Position.GetFirstPawn(couch.Map));
        }

        public override float GetPriority(Pawn pawn, TargetInfo t)
        {
            var patient = t.Cell.GetFirstPawn(t.Map);
            if (patient == null) return 0;
            if (patient.needs.mood == null) return 0;
            return (1 - patient.needs.mood.CurLevelPercentage)*10;
            //return t.Thing.GetStatValue(StatDefOf.SocialImpact);
        }
    }
}